<?php

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}
global $wpdb;
$tableuser    = $wpdb->prefix.'wpbot_sessions';
$session_exists = $wpdb->get_row($wpdb->prepare("select * from $tableuser where 1 and id = %d",1)); //DB Call OK, No Caching OK

if(!empty($session_exists)){
    $total_session = $session_exists->session;
}else{
    $total_session = 0;
}
?>


<div class="wp-chatbot-wrap-outer">

<div class="wp-chatbot-wrap">


    <div class="wpbot_dashboard_header"><h1><?php esc_html_e('WPBot Dashboard', 'chatbot'); ?></h1> <p><strong>Core Version:</strong> v<?php echo QCLD_wpCHATBOT_VERSION; ?></p></div>
    <div class="wpbot_addons_section qcld-main-wrapper">
        <div class="wpbot_single_addon_wrapper">
            
        
            <div class="wpbot_single_addon">
                <div class="wpbot_single_content">
                    <div class="wpbot_addon_image">
                        <img src="<?php echo esc_url(QCLD_wpCHATBOT_PLUGIN_URL.'images/icon-0.png'); ?>" title="" />
                    </div>
                    <div class="wpbot_addon_content">
                        <div class="wpbot_addon_title"><?php esc_html_e('WPBot', 'chatbot'); ?></div>
                        <div class="wpbot_addon_details">
                            <span class="wp_addon_installed"><?php esc_html_e('Installed', 'chatbot'); ?></span>
                            <p><?php esc_html_e('Wordpress Chatbot by QuantumCloud', 'chatbot'); ?></p>
                            <a class="button button-secondary" href="<?php echo esc_url(admin_url('admin.php?page=wpbot')); ?>" > <?php esc_html_e('Settings', 'chatbot'); ?></a>
							<a class="button button-primary" href="https://www.wpbot.pro/" target="_blank" > <?php esc_html_e('Upgrade to Pro', 'chatbot'); ?></a>
                        </div>            
                    </div>

                </div>

            </div>
        
			<div class="wpbot_single_addon">
                <div class="wpbot_single_content">
                    <div class="wpbot_addon_image">
                        <img src="<?php echo esc_url(QCLD_wpCHATBOT_PLUGIN_URL.'images/woo-addon-256.png'); ?>" title="" />
                    </div>
                    <div class="wpbot_addon_content">
                        <div class="wpbot_addon_title"> <?php esc_html_e('Woocommerce Module', 'chatbot'); ?></div>
                        <div class="wpbot_addon_details">
                        <?php if(class_exists('QCLD_MAILING_LIST_INTEGRATION_ADDON')){
                                echo '<span class="wp_addon_installed">'. esc_html__('Installed', 'chatbot') .'</span>';
                            }else{
                                echo '<span class="wp_addon_notinstalled">'. esc_html__('Not Installed', 'chatbot') .'</span>';
                            } ?>
                        
                            <p><?php esc_html_e('WooCommerce ChatBot', 'chatbot'); ?></p>
                            <?php if(function_exists('qcpd_wpwc_addon_lang_init')){
                                ?>
                                <a class="button button-secondary" href="<?php echo esc_url(admin_url('admin.php?page=wpwc-settings-page')); ?>" ><?php esc_html_e('Settings', 'chatbot'); ?></a>
                                <?php
                            }else{
                                ?>
                                <a class="button button-secondary" href="https://www.wpbot.pro/" target="_blank" ><?php esc_html_e('Get It Now', 'chatbot'); ?></a>
                                <?php
                            } ?>
                        </div>            
                    </div>
                </div>
            </div>


		
            <div class="wpbot_single_addon">
                <div class="wpbot_single_content">
                    <div class="wpbot_addon_image">
                        <img src="<?php echo esc_url(QCLD_wpCHATBOT_PLUGIN_URL.'images/WPBot-LiveChat.png'); ?>" title="" />
                    </div>
                    <div class="wpbot_addon_content">
                        <div class="wpbot_addon_title"><?php esc_html_e('Bot - Live Chat', 'chatbot'); ?></div>
                        <div class="wpbot_addon_details">

                            <span class="wp_addon_notinstalled"> <?php esc_html_e('Not Installed', 'chatbot'); ?></span>

                            <p><?php esc_html_e('Live Chat integrated with WPBot Pro ', 'chatbot'); ?></p>
                            <a class="button button-secondary" href="https://www.wpbot.pro/" target="_blank" ><?php esc_html_e('Get It Now', 'chatbot'); ?></a>
                                
                        </div>            
                    </div>

                </div>

            </div>

            <div class="wpbot_single_addon">
                <div class="wpbot_single_content">
                    <div class="wpbot_addon_image">
                        <img src="<?php echo esc_url(QCLD_wpCHATBOT_PLUGIN_URL.'images/conversational-forns.png'); ?>" title="" />
                    </div>
                    <div class="wpbot_addon_content">
                        <div class="wpbot_addon_title"> <?php esc_html_e('Bot - Conversational Form', 'chatbot'); ?></div>
                        <div class="wpbot_addon_details">

                            <?php if(function_exists('qcld_formbuilder_do_calculation')){
                                $cfb = 'Pro';
                            }else{
                                $cfb = 'Free';
                            } ?>

                            <?php if(function_exists('qcformbuilder_forms_load')){
                                echo '<span class="wp_addon_installed">Installed '. esc_html( $cfb ).'</span>';
                            }else{
                                echo '<span class="wp_addon_notinstalled">'. esc_html__('Not Installed', 'chatbot') .'</span>';
                            } ?>
                            <p><?php esc_html_e('Conversational form builder Module', 'chatbot'); ?></p>
                            <?php if(function_exists('qcformbuilder_forms_load')){
                                ?>
                                <a class="button button-secondary" href="<?php echo esc_url(admin_url('admin.php?page=qcformbuilder-forms')); ?>" ><?php esc_html_e('Settings', 'chatbot'); ?></a>
                                <?php if($cfb=='Free'): ?>
                                <a class="button button-secondary" href="https://www.quantumcloud.com/products/conversations-and-form-builder/" target="_blank" >Upgrade to Pro <?php esc_html_e('Settings', 'chatbot'); ?></a>
                                <?php endif; ?>
                                <?php
                            }else{
                                ?>
                                <a class="button button-secondary" href="https://www.wpbot.pro/" target="_blank" ><?php esc_html_e('Get It Now', 'chatbot'); ?></a>
                                <?php
                            } ?>
                        </div>            
                    </div>

                </div>

            </div>

            <div class="wpbot_single_addon">
                <div class="wpbot_single_content">
                    <div class="wpbot_addon_image">
                        <img src="<?php echo esc_url(QCLD_wpCHATBOT_PLUGIN_URL.'images/custom-post-type-addon-logo.png'); ?>" title="" />
                    </div>
                    <div class="wpbot_addon_content">
                        <div class="wpbot_addon_title"><?php esc_html_e('Bot - Extended Search', 'chatbot'); ?></div>
                        <div class="wpbot_addon_details">
                            <span class="wp_addon_notinstalled"> <?php esc_html_e('Not Installed', 'chatbot'); ?></span>
                            
                            <p><?php esc_html_e('Extend Bot’s search power for WPBot Pro', 'chatbot'); ?></p>

                            <a class="button button-secondary" href="https://www.wpbot.pro/" target="_blank" ><?php esc_html_e('Get It Now', 'chatbot'); ?></a>
                                
                        </div>            
                    </div>
                </div>
            </div>

            <div class="wpbot_single_addon">
                <div class="wpbot_single_content">
                    <div class="wpbot_addon_image">
                        <img src="<?php echo esc_url(QCLD_wpCHATBOT_PLUGIN_URL.'images/messenger-chatbot.png'); ?>" title="" />
                    </div>
                    <div class="wpbot_addon_content">
                        <div class="wpbot_addon_title"><?php esc_html_e('Bot - Messenger', 'chatbot'); ?></div>
                        <div class="wpbot_addon_details">
                            
							<?php if(function_exists('qcpd_wpfb_messenger_checking_dependencies')){
                                echo '<span class="wp_addon_installed">'. esc_html__('Installed', 'chatbot') .'</span>';
                            }else{
                                echo '<span class="wp_addon_notinstalled">'. esc_html__('Not Installed', 'chatbot').'</span>';
                            } ?>
							
                            
                            
                            <p><?php esc_html_e('Messenger Chatbot for WPBot Pro', 'chatbot'); ?></p>
                            
							<?php if(function_exists('qcpd_wpfb_messenger_checking_dependencies')){
                                ?>
                            <a class="button button-secondary" href="<?php echo esc_url(admin_url('admin.php?page=wbfb-botsetting-page')); ?>" ><?php esc_html_e('Settings', 'chatbot'); ?></a>
							<?php }else{ ?>
                                <a class="button button-secondary" href="https://www.wpbot.pro/" target="_blank" ><?php esc_html_e('Get It Now', 'chatbot'); ?></a>
							<?php } ?>
                        </div>            
                    </div>
                </div>
            </div>

            <div class="wpbot_single_addon">
                <div class="wpbot_single_content">
                    <div class="wpbot_addon_image">
                        <img src="<?php echo esc_url(QCLD_wpCHATBOT_PLUGIN_URL.'images/chatbot-sesssion-save.png'); ?>" title="" />
                    </div>
                    <div class="wpbot_addon_content">
                        <div class="wpbot_addon_title"><?php esc_html_e('Bot - Session Save', 'chatbot'); ?></div>
                        <div class="wpbot_addon_details">
                            
                            <span class="wp_addon_notinstalled"><?php esc_html_e('Not Installed', 'chatbot'); ?></span>
                            <p><?php esc_html_e('Chat sessions for WPBot Pro', 'chatbot'); ?></p>
                            
                            <a class="button button-secondary" href="https://www.wpbot.pro/" target="_blank" ><?php esc_html_e('Get It Now', 'chatbot'); ?></a>
                               
                        </div>            
                    </div>
                </div>
            </div>

            <div class="wpbot_single_addon">
                <div class="wpbot_single_content">
                    <div class="wpbot_addon_image">
                        <img src="<?php echo esc_url(QCLD_wpCHATBOT_PLUGIN_URL.'images/white-label.png'); ?>" title="" />
                    </div>
                    <div class="wpbot_addon_content">
                        <div class="wpbot_addon_title"><?php esc_html_e('Bot - White Label', 'chatbot'); ?></div>
                        <div class="wpbot_addon_details">
                            <span class="wp_addon_notinstalled"><?php esc_html_e('Not Installed', 'chatbot'); ?></span>
                            <p><?php esc_html_e('Replace the branding for WPBot Pro', 'chatbot'); ?></p>
                            <a class="button button-secondary" href="https://www.wpbot.pro/" target="_blank" ><?php esc_html_e('Get It Now', 'chatbot'); ?></a>

                        </div>            
                    </div>
                </div>
            </div>

            <div class="wpbot_single_addon">
                <div class="wpbot_single_content">
                    <div class="wpbot_addon_image">
                        <img src="<?php echo esc_url(QCLD_wpCHATBOT_PLUGIN_URL.'images/mailing-list-integrationt%20(1).png'); ?>" title="" />
                    </div>
                    <div class="wpbot_addon_content">
                        <div class="wpbot_addon_title"><?php esc_html_e('Mailing List Integration', 'chatbot'); ?></div>
                        <div class="wpbot_addon_details">
                        
                            <span class="wp_addon_notinstalled"><?php esc_html_e('Not Installed', 'chatbot'); ?></span>

                            <p><?php esc_html_e('Mailchimp and Zapier for WPBot Pro', 'chatbot'); ?></p>
                            
                            <a class="button button-secondary" href="https://www.wpbot.pro/" target="_blank" ><?php esc_html_e('Get It Now', 'chatbot'); ?></a>
                                
                        </div>            
                    </div>
                </div>
            </div>
			<div class="wpbot_single_addon">
                <div class="wpbot_single_content">
                    <div class="wpbot_addon_image">
                        <img src="<?php echo esc_url(QCLD_wpCHATBOT_PLUGIN_URL.'images/simple-text-responses.png'); ?>" title="" />
                    </div>
                    <div class="wpbot_addon_content">
                        <div class="wpbot_addon_title"><?php esc_html_e('Chatbot STR Pro Module', 'chatbot'); ?></div>
                        <div class="wpbot_addon_details">
                        <?php if(function_exists('qcld_str_pro_dependency')){
                                echo '<span class="wp_addon_installed">'. esc_html__('Installed', 'chatbot').'</span>';
                            }else{
                                echo '<span class="wp_addon_notinstalled">'. esc_html__('Not Installed', 'chatbot').'</span>';
                            } ?>
                        
                            <p><?php esc_html_e('Addon plugin that extends feature of STR', 'chatbot'); ?></p>
                            <?php if(function_exists('qcld_str_pro_dependency')){
                                ?>
                                <a class="button button-secondary" href="<?php echo esc_url(admin_url('admin.php?page=simple-text-response')); ?>" ><?php esc_html_e('Settings', 'chatbot'); ?></a>
                                <?php
                            }else{
                                ?>
                                <a class="button button-secondary" href="https://www.wpbot.pro/" target="_blank" ><?php esc_html_e('Get It Now', 'chatbot'); ?></a>
                                <?php
                            } ?>
                        </div>            
                    </div>
                </div>
            </div>
			<div class="wpbot_single_addon">
                <div class="wpbot_single_content">
                    <div class="wpbot_addon_image">
                        <img src="<?php echo esc_url(QCLD_wpCHATBOT_PLUGIN_URL.'images/muli-lamguage.png'); ?>" title="" />
                    </div>
                    <div class="wpbot_addon_content">
                        <div class="wpbot_addon_title"><?php esc_html_e('Multi Language Module', 'chatbot'); ?></div>
                        <div class="wpbot_addon_details">
                        <?php if(class_exists('Qcld_Wpbot_Multilanguage')){
                                echo '<span class="wp_addon_installed">'. esc_html__('Installed', 'chatbot').'</span>';
                            }else{
                                echo '<span class="wp_addon_notinstalled">'.esc_html__('Not Installed', 'chatbot').'</span>';
                            } ?>
                        
                            <p><?php esc_html_e('Add multiple language for your ChatBot', 'chatbot'); ?></p>
                            <?php if(class_exists('Qcld_Wpbot_Multilanguage')){
                                ?>
                                <a class="button button-secondary" href="<?php echo esc_url(admin_url('admin.php?page=wpbotml-settings-page')); ?>" ><?php esc_html_e('Settings', 'chatbot'); ?></a>
                                <?php
                            }else{
                                ?>
                                <a class="button button-secondary" href="https://www.wpbot.pro/" target="_blank" ><?php esc_html_e('Get It Now', 'chatbot'); ?></a>
                                <?php
                            } ?>
                        </div>            
                    </div>
                </div>
            </div>

            <div class="wpbot_single_addon">
                <div class="wpbot_single_content">
                    <div class="wpbot_addon_image">
                        <img src="<?php echo esc_url(QCLD_wpCHATBOT_PLUGIN_URL.'images/voice-message.png'); ?>" title="" />
                    </div>
                    <div class="wpbot_addon_content">
                        <div class="wpbot_addon_title"><?php esc_html_e('Voice Message Module', 'chatbot'); ?></div>
                        <div class="wpbot_addon_details">
                        <?php if( is_plugin_active( 'voice-message-addon/wpbotvoicemessage.php' ) ){
                                echo '<span class="wp_addon_installed">'. esc_html__('Installed', 'chatbot'). '</span>';
                            }else{
                                echo '<span class="wp_addon_notinstalled">'. esc_html__('Not Installed', 'chatbot') . '</span>';
                            } ?>
                        
                            <p><?php esc_html_e('Voice Message Module for your ChatBot', 'chatbot'); ?></p>
                            <?php if( is_plugin_active( 'voice-message-addon/wpbotvoicemessage.php' ) ){
                                ?>
                                <a class="button button-secondary" href="<?php echo esc_url(admin_url('edit.php?post_type=qcldcontacter_record&page=qcld_wpvm_vmwbmdp_contacter_settings')); ?>" ><?php esc_html_e('Settings', 'chatbot'); ?></a>
                                <?php
                            }else{
                                ?>
                                <a class="button button-secondary" href="https://www.wpbot.pro/" target="_blank" ><?php esc_html_e('Get It Now', 'chatbot'); ?></a>
                                <?php
                            } ?>
                        </div>            
                    </div>
                </div>
            </div>

            <div class="wpbot_single_addon">
                <div class="wpbot_single_content">
                    <div class="wpbot_addon_image">
                        <img src="<?php echo esc_url(QCLD_wpCHATBOT_PLUGIN_URL.'images/telegram-addon.png'); ?>" title="" />
                    </div>
                    <div class="wpbot_addon_content">
                        <div class="wpbot_addon_title"><?php esc_html_e('Telegram Module', 'chatbot'); ?></div>
                        <div class="wpbot_addon_details">
                        <?php if( is_plugin_active( 'telegram-chatbot-addon/init.php' ) ){
                                echo '<span class="wp_addon_installed">'. esc_html__('Installed', 'chatbot') .'</span>';
                            }else{
                                echo '<span class="wp_addon_notinstalled">'. esc_html__('Not Installed', 'chatbot') .'</span>';
                            } ?>
                        
                            <p> <?php esc_html_e('To connect telegram with chatbot', 'chatbot'); ?></p>
                            <?php  if( is_plugin_active( 'telegram-chatbot-addon/init.php' ) ){
                                ?>
                                <a class="button button-secondary" href="<?php echo esc_url(admin_url('admin.php?page=simple-text-response')); ?>" ><?php esc_html_e('Settings', 'chatbot'); ?></a>
                                <?php
                            }else{
                                ?>
                                <a class="button button-secondary" href="https://www.wpbot.pro/" target="_blank" ><?php esc_html_e('Get It Now', 'chatbot'); ?></a>
                                <?php
                            } ?>
                        </div>            
                    </div>
                </div>
            </div>
			<div class="wpbot_single_addon">
                <div class="wpbot_single_content">
                    <div class="wpbot_addon_image">
                        <img src="<?php echo esc_url(QCLD_wpCHATBOT_PLUGIN_URL.'images/openAI.png'); ?>" title="" />
                    </div>
                    <div class="wpbot_addon_content">
                        <div class="wpbot_addon_title"><?php esc_html_e('Open AI Module', 'chatbot'); ?></div>
                        <div class="wpbot_addon_details">
                        <?php if( is_plugin_active( 'chatbot-openai-addon/qcld-bot-openai.php' ) ){
                                echo '<span class="wp_addon_installed">'. esc_html__('Installed', 'chatbot').'</span>';
                            }else{
                                echo '<span class="wp_addon_notinstalled">'. esc_html__('Not Installed', 'chatbot').'</span>';
                            } ?>
                        
                            <p><?php esc_html_e('To connect open AI with your ChatBot', 'chatbot'); ?></p>
                            <?php if( is_plugin_active( 'chatbot-openai-addon/qcld-bot-openai.php' ) ){
                                ?>
                                <a class="button button-secondary" href="<?php echo esc_url(admin_url('admin.php?page=wpbotml-settings-page')); ?>" ><?php esc_html_e('Settings', 'chatbot'); ?></a>
                                <?php
                            }else{
                                ?>
                                <a class="button button-secondary" href="https://www.wpbot.pro/" target="_blank" ><?php esc_html_e('Get It Now', 'chatbot'); ?></a>
                                <?php
                            } ?>
                        </div>            
                    </div>
                </div>
            </div>

            <div class="wpbot_single_addon">
                <div class="wpbot_single_content">
                    <div class="wpbot_addon_image">
                        <img src="<?php echo esc_url(QCLD_wpCHATBOT_PLUGIN_URL.'images/templates-addon.png'); ?>" title="" />
                    </div>
                    <div class="wpbot_addon_content">
                        <div class="wpbot_addon_title"><?php esc_html_e('Extended UI Module', 'chatbot'); ?></div>
                        <div class="wpbot_addon_details">
                        <?php if( is_plugin_active( 'chatbot-extended-ui/chatbot-extended-ui.php' ) ){
                                echo '<span class="wp_addon_installed">'. esc_html__('Installed', 'chatbot').'</span>';
                            }else{
                                echo '<span class="wp_addon_notinstalled">'. esc_html__('Not Installed', 'chatbot') .'</span>';
                            } ?>
                        
                            <p><?php esc_html_e('Extended UI of ChatBot', 'chatbot'); ?></p>
                            <?php if( is_plugin_active( 'chatbot-extended-ui/chatbot-extended-ui.php' ) ){
                                ?>
                                <a class="button button-secondary" href="<?php echo esc_url(admin_url('edit.php?post_type=qcldcontacter_record&page=qcld_wpvm_vmwbmdp_contacter_settings')); ?>" ><?php esc_html_e('Settings', 'chatbot'); ?></a>
                                <?php
                            }else{
                                ?>
                                <a class="button button-secondary" href="https://www.wpbot.pro/" target="_blank" ><?php esc_html_e('Get It Now', 'chatbot'); ?></a>
                                <?php
                            } ?>
                        </div>            
                    </div>
                </div>
            </div>
            <div class="wpbot_single_addon">
                <div class="wpbot_single_content">
                    <div class="wpbot_addon_image">
                        <img src="<?php echo esc_url(QCLD_wpCHATBOT_PLUGIN_URL.'images/WhatsApp-chatbot.png'); ?>" title="" />
                    </div>
                    <div class="wpbot_addon_content">
                        <div class="wpbot_addon_title"><?php esc_html_e('WhatsApp Module', 'chatbot'); ?></div>
                        <div class="wpbot_addon_details">
                        <?php if( is_plugin_active( 'whatsapp-chatbot-addon/whatsapp-chatbot-addon.php' ) ){
                                echo '<span class="wp_addon_installed">'. esc_html__('Installed', 'chatbot') .'</span>';
                            }else{
                                echo '<span class="wp_addon_notinstalled">'. esc_html__('Not Installed', 'chatbot') .'</span>';
                            } ?>
                        
                            <p><?php esc_html_e('Connect WhatsApp with ChatBot', 'chatbot'); ?></p>
                            <?php if( is_plugin_active( 'whatsapp-chatbot-addon/whatsapp-chatbot-addon.php' ) ){
                                ?>
                                <a class="button button-secondary" href="<?php echo esc_url(admin_url('edit.php?post_type=qcldcontacter_record&page=qcld_wpvm_vmwbmdp_contacter_settings')); ?>" ><?php esc_html_e('Settings', 'chatbot'); ?></a>
                                <?php
                            }else{
                                ?>
                                <a class="button button-secondary" href="https://www.wpbot.pro/" target="_blank" ><?php esc_html_e('Get It Now', 'chatbot'); ?></a>
                                <?php
                            } ?>
                        </div>            
                    </div>
                </div>
            </div>
            <div class="wpbot_single_addon">
                <div class="wpbot_single_content">
                    <div class="wpbot_addon_image">
                        <img src="<?php echo esc_url(QCLD_wpCHATBOT_PLUGIN_URL.'images/voice-logo.png'); ?>" title="" />
                    </div>
                    <div class="wpbot_addon_content">
                        <div class="wpbot_addon_title"><?php esc_html_e('Voice Module', 'chatbot'); ?></div>
                        <div class="wpbot_addon_details">
                        <?php if( is_plugin_active( 'voice-addon/init.php' ) ){
                                echo '<span class="wp_addon_installed">'. esc_html__('Installed', 'chatbot') . '</span>';
                            }else{
                                echo '<span class="wp_addon_notinstalled">'. esc_html__('Not Installed', 'chatbot').'</span>';
                            } ?>
                        
                            <p><?php esc_html_e('Add google voice assist with ChatBot', 'chatbot'); ?></p>
                            <?php if( is_plugin_active( 'voice-addon/init.php' ) ){
                                ?>
                                <a class="button button-secondary" href="<?php echo esc_url(admin_url('edit.php?post_type=qcldcontacter_record&page=qcld_wpvm_vmwbmdp_contacter_settings')); ?>" ><?php esc_html_e('Settings', 'chatbot'); ?></a>
                                <?php
                            }else{
                                ?>
                                <a class="button button-secondary" href="https://www.wpbot.pro/" target="_blank" ><?php esc_html_e('Get It Now', 'chatbot'); ?></a>
                                <?php
                            } ?>
                        </div>            
                    </div>
                </div>
            </div>
            <div style="clear:both"></div>
            
        </div>
		<div class="wpbot_statistics_area">
                <h2> <?php esc_html_e('WPBot Statistics', 'chatbot'); ?></h2>
                <div class="wpbot_report">
                    
                    <p><span class="wpbot_report_key"><?php esc_html_e('Total ChatBot Sessions', 'chatbot'); ?></span>:<span class="wpbot_report_value"><?php echo esc_html($total_session); ?></span></p>

                </div>
        </div>

    </div>
</div>
</div>



<div id="qcld-quick-flyout" >
    <div class="qcld-quick-flyout-items">
    <a href="https://wpbot.pro/docs/knowledgebase/getting-started-with-chatbot/" target="_blank" class="qcld-quick-flyout-button qcld-quick-flyout-item qcld-quick-flyout-premium" rel="noopener noreferrer" target="_blank" style="transition-delay: 0ms;">
                <div class="qcld-quick-flyout-label">
                    <div>Getting Started</div>
                </div>
                <i class="dashicons dashicons-admin-home"></i>
            </a>
            <a href="https://wpbot.pro/docs/kb-sections/chatbot-faqs/" target="_blank" class="qcld-quick-flyout-button qcld-quick-flyout-item" rel="noopener noreferrer" target="_blank" style="transition-delay: 60ms;">
                <div class="qcld-quick-flyout-label">
                    <div>FAQ</div>
                </div>
                <i class="dashicons dashicons-flag"></i>
            </a>
            <a href="https://wpbot.pro/docs/" target="_blank" class="qcld-quick-flyout-button qcld-quick-flyout-item" style="transition-delay: 90ms;">
                <div class="qcld-quick-flyout-label">
                    <div>Read the Documentation</div>
                </div>
                <i class="dashicons dashicons-sos"></i>
            </a>
            <a href="https://www.wpbot.pro/free-support/" target="_blank" class="qcld-quick-flyout-button qcld-quick-flyout-item" rel="noopener noreferrer" target="_blank" style="transition-delay: 120ms;">
                <div class="qcld-quick-flyout-label">
                    <div>Ask for Help</div>
                </div>
                <i class="dashicons dashicons-email"></i>
            </a>           
            <a href="https://www.wpbot.pro/" target="_blank" class="qcld-quick-flyout-button qcld-quick-flyout-item" style="transition-delay: 30ms;">
                <div class="qcld-quick-flyout-label">
                    <div>Check out the WPBot Demo</div>
                </div>
                <i class="dashicons dashicons-welcome-view-site"></i>
            </a>
            <a href="https://www.wpbot.pro/pricing/" target="_blank" class="qcld-quick-flyout-button qcld-quick-flyout-item qcld-quick-flyout-premium" rel="noopener noreferrer" target="_blank" style="transition-delay: 0ms;">
                <div class="qcld-quick-flyout-label">
                    <div>Upgrade to Premium</div>
                </div>
                <i class="dashicons dashicons-star-filled"></i>
            </a>
            </div>
    <a href="javascript:void(0);" class="qcld-quick-flyout-button qcld-quick-flyout-mascot">
        <div class="qcld-quick-flyout-label">
            <div>Start Here</div>
        </div>
        <img style="width:100%" src="<?php echo esc_url( QCLD_wpCHATBOT_IMG_URL . '/agent-01.png' ); ?>" alt="Dialogflow CX">
    </a>
</div>
